package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanConditionalActionArgs private(
  conditionalAction: Output[String],
  configId: Output[Int]
) derives ArgsEncoder

object BotmanConditionalActionArgs:
  def apply(
    conditionalAction: Input[String],
    configId: Input[Int]
  )(using Context): BotmanConditionalActionArgs =
    new BotmanConditionalActionArgs(
      conditionalAction = conditionalAction.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false)
    )
