package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanCustomBotCategory private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  categoryId: Output[String],
  configId: Output[Int],
  customBotCategory: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanCustomBotCategory:
  given outputOps: {} with
    extension(output: Output[BotmanCustomBotCategory])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def categoryId: Output[String] = output.flatMap(_.categoryId)
      def configId: Output[Int] = output.flatMap(_.configId)
      def customBotCategory: Output[String] = output.flatMap(_.customBotCategory)

def botmanCustomBotCategory(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanCustomBotCategoryArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanCustomBotCategory] = 
  ctx.registerResource[BotmanCustomBotCategory, BotmanCustomBotCategoryArgs]("akamai:index/botmanCustomBotCategory:BotmanCustomBotCategory", name, args, opts)

