package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanCustomBotCategoryAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  categoryId: Output[String],
  configId: Output[Int],
  customBotCategoryAction: Output[String],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanCustomBotCategoryAction:
  given outputOps: {} with
    extension(output: Output[BotmanCustomBotCategoryAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def categoryId: Output[String] = output.flatMap(_.categoryId)
      def configId: Output[Int] = output.flatMap(_.configId)
      def customBotCategoryAction: Output[String] = output.flatMap(_.customBotCategoryAction)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def botmanCustomBotCategoryAction(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanCustomBotCategoryActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanCustomBotCategoryAction] = 
  ctx.registerResource[BotmanCustomBotCategoryAction, BotmanCustomBotCategoryActionArgs]("akamai:index/botmanCustomBotCategoryAction:BotmanCustomBotCategoryAction", name, args, opts)

