package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanCustomBotCategoryActionArgs private(
  categoryId: Output[String],
  configId: Output[Int],
  customBotCategoryAction: Output[String],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object BotmanCustomBotCategoryActionArgs:
  def apply(
    categoryId: Input[String],
    configId: Input[Int],
    customBotCategoryAction: Input[String],
    securityPolicyId: Input[String]
  )(using Context): BotmanCustomBotCategoryActionArgs =
    new BotmanCustomBotCategoryActionArgs(
      categoryId = categoryId.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      customBotCategoryAction = customBotCategoryAction.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
