package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanCustomBotCategoryArgs private(
  configId: Output[Int],
  customBotCategory: Output[String]
) derives ArgsEncoder

object BotmanCustomBotCategoryArgs:
  def apply(
    configId: Input[Int],
    customBotCategory: Input[String]
  )(using Context): BotmanCustomBotCategoryArgs =
    new BotmanCustomBotCategoryArgs(
      configId = configId.asOutput(isSecret = false),
      customBotCategory = customBotCategory.asOutput(isSecret = false)
    )
