package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanCustomBotCategorySequence private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  categoryIds: Output[scala.collection.immutable.List[String]],
  configId: Output[Int]
) extends CustomResource derives ResourceDecoder

object BotmanCustomBotCategorySequence:
  given outputOps: {} with
    extension(output: Output[BotmanCustomBotCategorySequence])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def categoryIds: Output[scala.collection.immutable.List[String]] = output.flatMap(_.categoryIds)
      def configId: Output[Int] = output.flatMap(_.configId)

def botmanCustomBotCategorySequence(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanCustomBotCategorySequenceArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanCustomBotCategorySequence] = 
  ctx.registerResource[BotmanCustomBotCategorySequence, BotmanCustomBotCategorySequenceArgs]("akamai:index/botmanCustomBotCategorySequence:BotmanCustomBotCategorySequence", name, args, opts)

