package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanCustomBotCategorySequenceArgs private(
  categoryIds: Output[scala.collection.immutable.List[String]],
  configId: Output[Int]
) derives ArgsEncoder

object BotmanCustomBotCategorySequenceArgs:
  def apply(
    categoryIds: Input[List[Input[String]]],
    configId: Input[Int]
  )(using Context): BotmanCustomBotCategorySequenceArgs =
    new BotmanCustomBotCategorySequenceArgs(
      categoryIds = categoryIds.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false)
    )
