package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanCustomClient private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  customClient: Output[String],
  customClientId: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanCustomClient:
  given outputOps: {} with
    extension(output: Output[BotmanCustomClient])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def customClient: Output[String] = output.flatMap(_.customClient)
      def customClientId: Output[String] = output.flatMap(_.customClientId)

def botmanCustomClient(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanCustomClientArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanCustomClient] = 
  ctx.registerResource[BotmanCustomClient, BotmanCustomClientArgs]("akamai:index/botmanCustomClient:BotmanCustomClient", name, args, opts)

