package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanCustomClientArgs private(
  configId: Output[Int],
  customClient: Output[String]
) derives ArgsEncoder

object BotmanCustomClientArgs:
  def apply(
    configId: Input[Int],
    customClient: Input[String]
  )(using Context): BotmanCustomClientArgs =
    new BotmanCustomClientArgs(
      configId = configId.asOutput(isSecret = false),
      customClient = customClient.asOutput(isSecret = false)
    )
