package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanCustomClientSequence private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  customClientIds: Output[scala.collection.immutable.List[String]]
) extends CustomResource derives ResourceDecoder

object BotmanCustomClientSequence:
  given outputOps: {} with
    extension(output: Output[BotmanCustomClientSequence])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def customClientIds: Output[scala.collection.immutable.List[String]] = output.flatMap(_.customClientIds)

def botmanCustomClientSequence(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanCustomClientSequenceArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanCustomClientSequence] = 
  ctx.registerResource[BotmanCustomClientSequence, BotmanCustomClientSequenceArgs]("akamai:index/botmanCustomClientSequence:BotmanCustomClientSequence", name, args, opts)

