package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanCustomClientSequenceArgs private(
  configId: Output[Int],
  customClientIds: Output[scala.collection.immutable.List[String]]
) derives ArgsEncoder

object BotmanCustomClientSequenceArgs:
  def apply(
    configId: Input[Int],
    customClientIds: Input[List[Input[String]]]
  )(using Context): BotmanCustomClientSequenceArgs =
    new BotmanCustomClientSequenceArgs(
      configId = configId.asOutput(isSecret = false),
      customClientIds = customClientIds.asOutput(isSecret = false)
    )
