package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanCustomDefinedBot private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  botId: Output[String],
  configId: Output[Int],
  customDefinedBot: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanCustomDefinedBot:
  given outputOps: {} with
    extension(output: Output[BotmanCustomDefinedBot])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def botId: Output[String] = output.flatMap(_.botId)
      def configId: Output[Int] = output.flatMap(_.configId)
      def customDefinedBot: Output[String] = output.flatMap(_.customDefinedBot)

def botmanCustomDefinedBot(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanCustomDefinedBotArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanCustomDefinedBot] = 
  ctx.registerResource[BotmanCustomDefinedBot, BotmanCustomDefinedBotArgs]("akamai:index/botmanCustomDefinedBot:BotmanCustomDefinedBot", name, args, opts)

