package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanCustomDefinedBotArgs private(
  configId: Output[Int],
  customDefinedBot: Output[String]
) derives ArgsEncoder

object BotmanCustomDefinedBotArgs:
  def apply(
    configId: Input[Int],
    customDefinedBot: Input[String]
  )(using Context): BotmanCustomDefinedBotArgs =
    new BotmanCustomDefinedBotArgs(
      configId = configId.asOutput(isSecret = false),
      customDefinedBot = customDefinedBot.asOutput(isSecret = false)
    )
