package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanCustomDenyAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  actionId: Output[String],
  configId: Output[Int],
  customDenyAction: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanCustomDenyAction:
  given outputOps: {} with
    extension(output: Output[BotmanCustomDenyAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def actionId: Output[String] = output.flatMap(_.actionId)
      def configId: Output[Int] = output.flatMap(_.configId)
      def customDenyAction: Output[String] = output.flatMap(_.customDenyAction)

def botmanCustomDenyAction(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanCustomDenyActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanCustomDenyAction] = 
  ctx.registerResource[BotmanCustomDenyAction, BotmanCustomDenyActionArgs]("akamai:index/botmanCustomDenyAction:BotmanCustomDenyAction", name, args, opts)

