package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanCustomDenyActionArgs private(
  configId: Output[Int],
  customDenyAction: Output[String]
) derives ArgsEncoder

object BotmanCustomDenyActionArgs:
  def apply(
    configId: Input[Int],
    customDenyAction: Input[String]
  )(using Context): BotmanCustomDenyActionArgs =
    new BotmanCustomDenyActionArgs(
      configId = configId.asOutput(isSecret = false),
      customDenyAction = customDenyAction.asOutput(isSecret = false)
    )
