package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanJavascriptInjection private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  javascriptInjection: Output[String],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanJavascriptInjection:
  given outputOps: {} with
    extension(output: Output[BotmanJavascriptInjection])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def javascriptInjection: Output[String] = output.flatMap(_.javascriptInjection)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def botmanJavascriptInjection(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanJavascriptInjectionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanJavascriptInjection] = 
  ctx.registerResource[BotmanJavascriptInjection, BotmanJavascriptInjectionArgs]("akamai:index/botmanJavascriptInjection:BotmanJavascriptInjection", name, args, opts)

