package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanJavascriptInjectionArgs private(
  configId: Output[Int],
  javascriptInjection: Output[String],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object BotmanJavascriptInjectionArgs:
  def apply(
    configId: Input[Int],
    javascriptInjection: Input[String],
    securityPolicyId: Input[String]
  )(using Context): BotmanJavascriptInjectionArgs =
    new BotmanJavascriptInjectionArgs(
      configId = configId.asOutput(isSecret = false),
      javascriptInjection = javascriptInjection.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
