package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanRecategorizedAkamaiDefinedBot private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  botId: Output[String],
  categoryId: Output[String],
  configId: Output[Int]
) extends CustomResource derives ResourceDecoder

object BotmanRecategorizedAkamaiDefinedBot:
  given outputOps: {} with
    extension(output: Output[BotmanRecategorizedAkamaiDefinedBot])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def botId: Output[String] = output.flatMap(_.botId)
      def categoryId: Output[String] = output.flatMap(_.categoryId)
      def configId: Output[Int] = output.flatMap(_.configId)

def botmanRecategorizedAkamaiDefinedBot(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanRecategorizedAkamaiDefinedBotArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanRecategorizedAkamaiDefinedBot] = 
  ctx.registerResource[BotmanRecategorizedAkamaiDefinedBot, BotmanRecategorizedAkamaiDefinedBotArgs]("akamai:index/botmanRecategorizedAkamaiDefinedBot:BotmanRecategorizedAkamaiDefinedBot", name, args, opts)

