package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanRecategorizedAkamaiDefinedBotArgs private(
  botId: Output[String],
  categoryId: Output[String],
  configId: Output[Int]
) derives ArgsEncoder

object BotmanRecategorizedAkamaiDefinedBotArgs:
  def apply(
    botId: Input[String],
    categoryId: Input[String],
    configId: Input[Int]
  )(using Context): BotmanRecategorizedAkamaiDefinedBotArgs =
    new BotmanRecategorizedAkamaiDefinedBotArgs(
      botId = botId.asOutput(isSecret = false),
      categoryId = categoryId.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false)
    )
