package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanServeAlternateAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  actionId: Output[String],
  configId: Output[Int],
  serveAlternateAction: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanServeAlternateAction:
  given outputOps: {} with
    extension(output: Output[BotmanServeAlternateAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def actionId: Output[String] = output.flatMap(_.actionId)
      def configId: Output[Int] = output.flatMap(_.configId)
      def serveAlternateAction: Output[String] = output.flatMap(_.serveAlternateAction)

def botmanServeAlternateAction(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanServeAlternateActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanServeAlternateAction] = 
  ctx.registerResource[BotmanServeAlternateAction, BotmanServeAlternateActionArgs]("akamai:index/botmanServeAlternateAction:BotmanServeAlternateAction", name, args, opts)

