package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanServeAlternateActionArgs private(
  configId: Output[Int],
  serveAlternateAction: Output[String]
) derives ArgsEncoder

object BotmanServeAlternateActionArgs:
  def apply(
    configId: Input[Int],
    serveAlternateAction: Input[String]
  )(using Context): BotmanServeAlternateActionArgs =
    new BotmanServeAlternateActionArgs(
      configId = configId.asOutput(isSecret = false),
      serveAlternateAction = serveAlternateAction.asOutput(isSecret = false)
    )
