package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanTransactionalEndpoint private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  operationId: Output[String],
  securityPolicyId: Output[String],
  transactionalEndpoint: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanTransactionalEndpoint:
  given outputOps: {} with
    extension(output: Output[BotmanTransactionalEndpoint])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def operationId: Output[String] = output.flatMap(_.operationId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)
      def transactionalEndpoint: Output[String] = output.flatMap(_.transactionalEndpoint)

def botmanTransactionalEndpoint(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanTransactionalEndpointArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanTransactionalEndpoint] = 
  ctx.registerResource[BotmanTransactionalEndpoint, BotmanTransactionalEndpointArgs]("akamai:index/botmanTransactionalEndpoint:BotmanTransactionalEndpoint", name, args, opts)

