package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanTransactionalEndpointArgs private(
  configId: Output[Int],
  operationId: Output[String],
  securityPolicyId: Output[String],
  transactionalEndpoint: Output[String]
) derives ArgsEncoder

object BotmanTransactionalEndpointArgs:
  def apply(
    configId: Input[Int],
    operationId: Input[String],
    securityPolicyId: Input[String],
    transactionalEndpoint: Input[String]
  )(using Context): BotmanTransactionalEndpointArgs =
    new BotmanTransactionalEndpointArgs(
      configId = configId.asOutput(isSecret = false),
      operationId = operationId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false),
      transactionalEndpoint = transactionalEndpoint.asOutput(isSecret = false)
    )
