package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanTransactionalEndpointProtection private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  transactionalEndpointProtection: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanTransactionalEndpointProtection:
  given outputOps: {} with
    extension(output: Output[BotmanTransactionalEndpointProtection])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def transactionalEndpointProtection: Output[String] = output.flatMap(_.transactionalEndpointProtection)

def botmanTransactionalEndpointProtection(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanTransactionalEndpointProtectionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanTransactionalEndpointProtection] = 
  ctx.registerResource[BotmanTransactionalEndpointProtection, BotmanTransactionalEndpointProtectionArgs]("akamai:index/botmanTransactionalEndpointProtection:BotmanTransactionalEndpointProtection", name, args, opts)

