package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanTransactionalEndpointProtectionArgs private(
  configId: Output[Int],
  transactionalEndpointProtection: Output[String]
) derives ArgsEncoder

object BotmanTransactionalEndpointProtectionArgs:
  def apply(
    configId: Input[Int],
    transactionalEndpointProtection: Input[String]
  )(using Context): BotmanTransactionalEndpointProtectionArgs =
    new BotmanTransactionalEndpointProtectionArgs(
      configId = configId.asOutput(isSecret = false),
      transactionalEndpointProtection = transactionalEndpointProtection.asOutput(isSecret = false)
    )
