package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ClientlistActivation private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  comments: Output[Option[String]],
  listId: Output[String],
  network: Output[String],
  notificationRecipients: Output[Option[scala.collection.immutable.List[String]]],
  siebelTicketId: Output[Option[String]],
  status: Output[String],
  version: Output[Int]
) extends CustomResource derives ResourceDecoder

object ClientlistActivation:
  given outputOps: {} with
    extension(output: Output[ClientlistActivation])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def comments: Output[Option[String]] = output.flatMap(_.comments)
      def listId: Output[String] = output.flatMap(_.listId)
      def network: Output[String] = output.flatMap(_.network)
      def notificationRecipients: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.notificationRecipients)
      def siebelTicketId: Output[Option[String]] = output.flatMap(_.siebelTicketId)
      def status: Output[String] = output.flatMap(_.status)
      def version: Output[Int] = output.flatMap(_.version)

def clientlistActivation(using ctx: Context)(
  name: NonEmptyString,
  args: ClientlistActivationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ClientlistActivation] = 
  ctx.registerResource[ClientlistActivation, ClientlistActivationArgs]("akamai:index/clientlistActivation:ClientlistActivation", name, args, opts)

