package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ClientlistActivationArgs private(
  comments: Output[Option[String]],
  listId: Output[String],
  network: Output[String],
  notificationRecipients: Output[Option[scala.collection.immutable.List[String]]],
  siebelTicketId: Output[Option[String]],
  version: Output[Int]
) derives ArgsEncoder

object ClientlistActivationArgs:
  def apply(
    comments: Input.Optional[String] = None,
    listId: Input[String],
    network: Input[String],
    notificationRecipients: Input.Optional[List[Input[String]]] = None,
    siebelTicketId: Input.Optional[String] = None,
    version: Input[Int]
  )(using Context): ClientlistActivationArgs =
    new ClientlistActivationArgs(
      comments = comments.asOptionOutput(isSecret = false),
      listId = listId.asOutput(isSecret = false),
      network = network.asOutput(isSecret = false),
      notificationRecipients = notificationRecipients.asOptionOutput(isSecret = false),
      siebelTicketId = siebelTicketId.asOptionOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
