package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ClientlistList private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  contractId: Output[String],
  groupId: Output[Int],
  items: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.ClientlistListItem]]],
  itemsCount: Output[Int],
  listId: Output[String],
  name: Output[String],
  notes: Output[Option[String]],
  tags: Output[Option[scala.collection.immutable.List[String]]],
  `type`: Output[String],
  version: Output[Int]
) extends CustomResource derives ResourceDecoder

object ClientlistList:
  given outputOps: {} with
    extension(output: Output[ClientlistList])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def groupId: Output[Int] = output.flatMap(_.groupId)
      def items: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.ClientlistListItem]]] = output.flatMap(_.items)
      def itemsCount: Output[Int] = output.flatMap(_.itemsCount)
      def listId: Output[String] = output.flatMap(_.listId)
      def name: Output[String] = output.flatMap(_.name)
      def notes: Output[Option[String]] = output.flatMap(_.notes)
      def tags: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.tags)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def version: Output[Int] = output.flatMap(_.version)

def clientlistList(using ctx: Context)(
  name: NonEmptyString,
  args: ClientlistListArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ClientlistList] = 
  ctx.registerResource[ClientlistList, ClientlistListArgs]("akamai:index/clientlistList:ClientlistList", name, args, opts)

