package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ClientlistListArgs private(
  contractId: Output[String],
  groupId: Output[Int],
  items: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.ClientlistListItemArgs]]],
  name: Output[Option[String]],
  notes: Output[Option[String]],
  tags: Output[Option[scala.collection.immutable.List[String]]],
  `type`: Output[String]
) derives ArgsEncoder

object ClientlistListArgs:
  def apply(
    contractId: Input[String],
    groupId: Input[Int],
    items: Input.Optional[List[Input[besom.api.akamai.inputs.ClientlistListItemArgs]]] = None,
    name: Input.Optional[String] = None,
    notes: Input.Optional[String] = None,
    tags: Input.Optional[List[Input[String]]] = None,
    `type`: Input[String]
  )(using Context): ClientlistListArgs =
    new ClientlistListArgs(
      contractId = contractId.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      items = items.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      notes = notes.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
