package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CloudletsApplicationLoadBalancer private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  balancingType: Output[Option[String]],
  dataCenters: Output[scala.collection.immutable.List[besom.api.akamai.outputs.CloudletsApplicationLoadBalancerDataCenter]],
  description: Output[Option[String]],
  livenessSettings: Output[Option[besom.api.akamai.outputs.CloudletsApplicationLoadBalancerLivenessSettings]],
  originId: Output[String],
  version: Output[Int],
  warnings: Output[String]
) extends CustomResource derives ResourceDecoder

object CloudletsApplicationLoadBalancer:
  given outputOps: {} with
    extension(output: Output[CloudletsApplicationLoadBalancer])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def balancingType: Output[Option[String]] = output.flatMap(_.balancingType)
      def dataCenters: Output[scala.collection.immutable.List[besom.api.akamai.outputs.CloudletsApplicationLoadBalancerDataCenter]] = output.flatMap(_.dataCenters)
      def description: Output[Option[String]] = output.flatMap(_.description)
      def livenessSettings: Output[Option[besom.api.akamai.outputs.CloudletsApplicationLoadBalancerLivenessSettings]] = output.flatMap(_.livenessSettings)
      def originId: Output[String] = output.flatMap(_.originId)
      def version: Output[Int] = output.flatMap(_.version)
      def warnings: Output[String] = output.flatMap(_.warnings)

def cloudletsApplicationLoadBalancer(using ctx: Context)(
  name: NonEmptyString,
  args: CloudletsApplicationLoadBalancerArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CloudletsApplicationLoadBalancer] = 
  ctx.registerResource[CloudletsApplicationLoadBalancer, CloudletsApplicationLoadBalancerArgs]("akamai:index/cloudletsApplicationLoadBalancer:CloudletsApplicationLoadBalancer", name, args, opts)

