package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CloudletsApplicationLoadBalancerActivation private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  network: Output[String],
  originId: Output[String],
  status: Output[String],
  version: Output[Int]
) extends CustomResource derives ResourceDecoder

object CloudletsApplicationLoadBalancerActivation:
  given outputOps: {} with
    extension(output: Output[CloudletsApplicationLoadBalancerActivation])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def network: Output[String] = output.flatMap(_.network)
      def originId: Output[String] = output.flatMap(_.originId)
      def status: Output[String] = output.flatMap(_.status)
      def version: Output[Int] = output.flatMap(_.version)

def cloudletsApplicationLoadBalancerActivation(using ctx: Context)(
  name: NonEmptyString,
  args: CloudletsApplicationLoadBalancerActivationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CloudletsApplicationLoadBalancerActivation] = 
  ctx.registerResource[CloudletsApplicationLoadBalancerActivation, CloudletsApplicationLoadBalancerActivationArgs]("akamai:index/cloudletsApplicationLoadBalancerActivation:CloudletsApplicationLoadBalancerActivation", name, args, opts)

