package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CloudletsApplicationLoadBalancerActivationArgs private(
  network: Output[String],
  originId: Output[String],
  version: Output[Int]
) derives ArgsEncoder

object CloudletsApplicationLoadBalancerActivationArgs:
  def apply(
    network: Input[String],
    originId: Input[String],
    version: Input[Int]
  )(using Context): CloudletsApplicationLoadBalancerActivationArgs =
    new CloudletsApplicationLoadBalancerActivationArgs(
      network = network.asOutput(isSecret = false),
      originId = originId.asOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
