package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CloudletsApplicationLoadBalancerArgs private(
  balancingType: Output[Option[String]],
  dataCenters: Output[scala.collection.immutable.List[besom.api.akamai.inputs.CloudletsApplicationLoadBalancerDataCenterArgs]],
  description: Output[Option[String]],
  livenessSettings: Output[Option[besom.api.akamai.inputs.CloudletsApplicationLoadBalancerLivenessSettingsArgs]],
  originId: Output[String]
) derives ArgsEncoder

object CloudletsApplicationLoadBalancerArgs:
  def apply(
    balancingType: Input.Optional[String] = None,
    dataCenters: Input[List[Input[besom.api.akamai.inputs.CloudletsApplicationLoadBalancerDataCenterArgs]]],
    description: Input.Optional[String] = None,
    livenessSettings: Input.Optional[besom.api.akamai.inputs.CloudletsApplicationLoadBalancerLivenessSettingsArgs] = None,
    originId: Input[String]
  )(using Context): CloudletsApplicationLoadBalancerArgs =
    new CloudletsApplicationLoadBalancerArgs(
      balancingType = balancingType.asOptionOutput(isSecret = false),
      dataCenters = dataCenters.asOutput(isSecret = false),
      description = description.asOptionOutput(isSecret = false),
      livenessSettings = livenessSettings.asOptionOutput(isSecret = false),
      originId = originId.asOutput(isSecret = false)
    )
