package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CloudletsPolicy private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  cloudletCode: Output[String],
  cloudletId: Output[Int],
  description: Output[Option[String]],
  groupId: Output[String],
  matchRuleFormat: Output[Option[String]],
  matchRules: Output[Option[String]],
  name: Output[String],
  version: Output[Int],
  warnings: Output[String]
) extends CustomResource derives ResourceDecoder

object CloudletsPolicy:
  given outputOps: {} with
    extension(output: Output[CloudletsPolicy])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def cloudletCode: Output[String] = output.flatMap(_.cloudletCode)
      def cloudletId: Output[Int] = output.flatMap(_.cloudletId)
      def description: Output[Option[String]] = output.flatMap(_.description)
      def groupId: Output[String] = output.flatMap(_.groupId)
      def matchRuleFormat: Output[Option[String]] = output.flatMap(_.matchRuleFormat)
      def matchRules: Output[Option[String]] = output.flatMap(_.matchRules)
      def name: Output[String] = output.flatMap(_.name)
      def version: Output[Int] = output.flatMap(_.version)
      def warnings: Output[String] = output.flatMap(_.warnings)

def cloudletsPolicy(using ctx: Context)(
  name: NonEmptyString,
  args: CloudletsPolicyArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CloudletsPolicy] = 
  ctx.registerResource[CloudletsPolicy, CloudletsPolicyArgs]("akamai:index/cloudletsPolicy:CloudletsPolicy", name, args, opts)

