package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CloudletsPolicyActivation private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  associatedProperties: Output[scala.collection.immutable.List[String]],
  network: Output[String],
  policyId: Output[Int],
  status: Output[String],
  version: Output[Int]
) extends CustomResource derives ResourceDecoder

object CloudletsPolicyActivation:
  given outputOps: {} with
    extension(output: Output[CloudletsPolicyActivation])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def associatedProperties: Output[scala.collection.immutable.List[String]] = output.flatMap(_.associatedProperties)
      def network: Output[String] = output.flatMap(_.network)
      def policyId: Output[Int] = output.flatMap(_.policyId)
      def status: Output[String] = output.flatMap(_.status)
      def version: Output[Int] = output.flatMap(_.version)

def cloudletsPolicyActivation(using ctx: Context)(
  name: NonEmptyString,
  args: CloudletsPolicyActivationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CloudletsPolicyActivation] = 
  ctx.registerResource[CloudletsPolicyActivation, CloudletsPolicyActivationArgs]("akamai:index/cloudletsPolicyActivation:CloudletsPolicyActivation", name, args, opts)

