package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CloudletsPolicyActivationArgs private(
  associatedProperties: Output[scala.collection.immutable.List[String]],
  network: Output[String],
  policyId: Output[Int],
  version: Output[Int]
) derives ArgsEncoder

object CloudletsPolicyActivationArgs:
  def apply(
    associatedProperties: Input[List[Input[String]]],
    network: Input[String],
    policyId: Input[Int],
    version: Input[Int]
  )(using Context): CloudletsPolicyActivationArgs =
    new CloudletsPolicyActivationArgs(
      associatedProperties = associatedProperties.asOutput(isSecret = false),
      network = network.asOutput(isSecret = false),
      policyId = policyId.asOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
