package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CloudletsPolicyArgs private(
  cloudletCode: Output[String],
  description: Output[Option[String]],
  groupId: Output[String],
  matchRuleFormat: Output[Option[String]],
  matchRules: Output[Option[String]],
  name: Output[Option[String]]
) derives ArgsEncoder

object CloudletsPolicyArgs:
  def apply(
    cloudletCode: Input[String],
    description: Input.Optional[String] = None,
    groupId: Input[String],
    matchRuleFormat: Input.Optional[String] = None,
    matchRules: Input.Optional[String] = None,
    name: Input.Optional[String] = None
  )(using Context): CloudletsPolicyArgs =
    new CloudletsPolicyArgs(
      cloudletCode = cloudletCode.asOutput(isSecret = false),
      description = description.asOptionOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      matchRuleFormat = matchRuleFormat.asOptionOutput(isSecret = false),
      matchRules = matchRules.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false)
    )
