package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CloudwrapperActivation private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  revision: Output[String],
  timeouts: Output[Option[besom.api.akamai.outputs.CloudwrapperActivationTimeouts]]
) extends CustomResource derives ResourceDecoder

object CloudwrapperActivation:
  given outputOps: {} with
    extension(output: Output[CloudwrapperActivation])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def revision: Output[String] = output.flatMap(_.revision)
      def timeouts: Output[Option[besom.api.akamai.outputs.CloudwrapperActivationTimeouts]] = output.flatMap(_.timeouts)

def cloudwrapperActivation(using ctx: Context)(
  name: NonEmptyString,
  args: CloudwrapperActivationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CloudwrapperActivation] = 
  ctx.registerResource[CloudwrapperActivation, CloudwrapperActivationArgs]("akamai:index/cloudwrapperActivation:CloudwrapperActivation", name, args, opts)

