package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CloudwrapperActivationArgs private(
  configId: Output[Int],
  revision: Output[String],
  timeouts: Output[Option[besom.api.akamai.inputs.CloudwrapperActivationTimeoutsArgs]]
) derives ArgsEncoder

object CloudwrapperActivationArgs:
  def apply(
    configId: Input[Int],
    revision: Input[String],
    timeouts: Input.Optional[besom.api.akamai.inputs.CloudwrapperActivationTimeoutsArgs] = None
  )(using Context): CloudwrapperActivationArgs =
    new CloudwrapperActivationArgs(
      configId = configId.asOutput(isSecret = false),
      revision = revision.asOutput(isSecret = false),
      timeouts = timeouts.asOptionOutput(isSecret = false)
    )
