package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CloudwrapperConfiguration private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  capacityAlertsThreshold: Output[Option[Int]],
  comments: Output[String],
  configName: Output[String],
  contractId: Output[String],
  locations: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.CloudwrapperConfigurationLocation]]],
  notificationEmails: Output[scala.collection.immutable.List[String]],
  propertyIds: Output[scala.collection.immutable.List[String]],
  retainIdleObjects: Output[Boolean],
  revision: Output[String],
  timeouts: Output[Option[besom.api.akamai.outputs.CloudwrapperConfigurationTimeouts]]
) extends CustomResource derives ResourceDecoder

object CloudwrapperConfiguration:
  given outputOps: {} with
    extension(output: Output[CloudwrapperConfiguration])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def capacityAlertsThreshold: Output[Option[Int]] = output.flatMap(_.capacityAlertsThreshold)
      def comments: Output[String] = output.flatMap(_.comments)
      def configName: Output[String] = output.flatMap(_.configName)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def locations: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.CloudwrapperConfigurationLocation]]] = output.flatMap(_.locations)
      def notificationEmails: Output[scala.collection.immutable.List[String]] = output.flatMap(_.notificationEmails)
      def propertyIds: Output[scala.collection.immutable.List[String]] = output.flatMap(_.propertyIds)
      def retainIdleObjects: Output[Boolean] = output.flatMap(_.retainIdleObjects)
      def revision: Output[String] = output.flatMap(_.revision)
      def timeouts: Output[Option[besom.api.akamai.outputs.CloudwrapperConfigurationTimeouts]] = output.flatMap(_.timeouts)

def cloudwrapperConfiguration(using ctx: Context)(
  name: NonEmptyString,
  args: CloudwrapperConfigurationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CloudwrapperConfiguration] = 
  ctx.registerResource[CloudwrapperConfiguration, CloudwrapperConfigurationArgs]("akamai:index/cloudwrapperConfiguration:CloudwrapperConfiguration", name, args, opts)

