package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CloudwrapperConfigurationArgs private(
  capacityAlertsThreshold: Output[Option[Int]],
  comments: Output[String],
  configName: Output[String],
  contractId: Output[String],
  locations: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.CloudwrapperConfigurationLocationArgs]]],
  notificationEmails: Output[Option[scala.collection.immutable.List[String]]],
  propertyIds: Output[scala.collection.immutable.List[String]],
  retainIdleObjects: Output[Option[Boolean]],
  timeouts: Output[Option[besom.api.akamai.inputs.CloudwrapperConfigurationTimeoutsArgs]]
) derives ArgsEncoder

object CloudwrapperConfigurationArgs:
  def apply(
    capacityAlertsThreshold: Input.Optional[Int] = None,
    comments: Input[String],
    configName: Input[String],
    contractId: Input[String],
    locations: Input.Optional[List[Input[besom.api.akamai.inputs.CloudwrapperConfigurationLocationArgs]]] = None,
    notificationEmails: Input.Optional[List[Input[String]]] = None,
    propertyIds: Input[List[Input[String]]],
    retainIdleObjects: Input.Optional[Boolean] = None,
    timeouts: Input.Optional[besom.api.akamai.inputs.CloudwrapperConfigurationTimeoutsArgs] = None
  )(using Context): CloudwrapperConfigurationArgs =
    new CloudwrapperConfigurationArgs(
      capacityAlertsThreshold = capacityAlertsThreshold.asOptionOutput(isSecret = false),
      comments = comments.asOutput(isSecret = false),
      configName = configName.asOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      locations = locations.asOptionOutput(isSecret = false),
      notificationEmails = notificationEmails.asOptionOutput(isSecret = false),
      propertyIds = propertyIds.asOutput(isSecret = false),
      retainIdleObjects = retainIdleObjects.asOptionOutput(isSecret = false),
      timeouts = timeouts.asOptionOutput(isSecret = false)
    )
