package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CpCode private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  contractId: Output[String],
  groupId: Output[String],
  name: Output[String],
  productId: Output[String]
) extends CustomResource derives ResourceDecoder

object CpCode:
  given outputOps: {} with
    extension(output: Output[CpCode])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def groupId: Output[String] = output.flatMap(_.groupId)
      def name: Output[String] = output.flatMap(_.name)
      def productId: Output[String] = output.flatMap(_.productId)

def cpCode(using ctx: Context)(
  name: NonEmptyString,
  args: CpCodeArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CpCode] = 
  ctx.registerResource[CpCode, CpCodeArgs]("akamai:index/cpCode:CpCode", name, args, opts)

