package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CpCodeArgs private(
  contractId: Output[String],
  groupId: Output[String],
  name: Output[Option[String]],
  productId: Output[Option[String]]
) derives ArgsEncoder

object CpCodeArgs:
  def apply(
    contractId: Input[String],
    groupId: Input[String],
    name: Input.Optional[String] = None,
    productId: Input.Optional[String] = None
  )(using Context): CpCodeArgs =
    new CpCodeArgs(
      contractId = contractId.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      productId = productId.asOptionOutput(isSecret = false)
    )
