package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CpsDvEnrollment private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  acknowledgePreVerificationWarnings: Output[Option[Boolean]],
  adminContact: Output[besom.api.akamai.outputs.CpsDvEnrollmentAdminContact],
  allowDuplicateCommonName: Output[Option[Boolean]],
  certificateChainType: Output[Option[String]],
  certificateType: Output[String],
  commonName: Output[String],
  contractId: Output[String],
  csr: Output[besom.api.akamai.outputs.CpsDvEnrollmentCsr],
  dnsChallenges: Output[scala.collection.immutable.List[besom.api.akamai.outputs.CpsDvEnrollmentDnsChallenge]],
  httpChallenges: Output[scala.collection.immutable.List[besom.api.akamai.outputs.CpsDvEnrollmentHttpChallenge]],
  networkConfiguration: Output[besom.api.akamai.outputs.CpsDvEnrollmentNetworkConfiguration],
  organization: Output[besom.api.akamai.outputs.CpsDvEnrollmentOrganization],
  registrationAuthority: Output[String],
  sans: Output[Option[scala.collection.immutable.List[String]]],
  secureNetwork: Output[String],
  signatureAlgorithm: Output[String],
  sniOnly: Output[Boolean],
  techContact: Output[besom.api.akamai.outputs.CpsDvEnrollmentTechContact],
  validationType: Output[String]
) extends CustomResource derives ResourceDecoder

object CpsDvEnrollment:
  given outputOps: {} with
    extension(output: Output[CpsDvEnrollment])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def acknowledgePreVerificationWarnings: Output[Option[Boolean]] = output.flatMap(_.acknowledgePreVerificationWarnings)
      def adminContact: Output[besom.api.akamai.outputs.CpsDvEnrollmentAdminContact] = output.flatMap(_.adminContact)
      def allowDuplicateCommonName: Output[Option[Boolean]] = output.flatMap(_.allowDuplicateCommonName)
      def certificateChainType: Output[Option[String]] = output.flatMap(_.certificateChainType)
      def certificateType: Output[String] = output.flatMap(_.certificateType)
      def commonName: Output[String] = output.flatMap(_.commonName)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def csr: Output[besom.api.akamai.outputs.CpsDvEnrollmentCsr] = output.flatMap(_.csr)
      def dnsChallenges: Output[scala.collection.immutable.List[besom.api.akamai.outputs.CpsDvEnrollmentDnsChallenge]] = output.flatMap(_.dnsChallenges)
      def httpChallenges: Output[scala.collection.immutable.List[besom.api.akamai.outputs.CpsDvEnrollmentHttpChallenge]] = output.flatMap(_.httpChallenges)
      def networkConfiguration: Output[besom.api.akamai.outputs.CpsDvEnrollmentNetworkConfiguration] = output.flatMap(_.networkConfiguration)
      def organization: Output[besom.api.akamai.outputs.CpsDvEnrollmentOrganization] = output.flatMap(_.organization)
      def registrationAuthority: Output[String] = output.flatMap(_.registrationAuthority)
      def sans: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.sans)
      def secureNetwork: Output[String] = output.flatMap(_.secureNetwork)
      def signatureAlgorithm: Output[String] = output.flatMap(_.signatureAlgorithm)
      def sniOnly: Output[Boolean] = output.flatMap(_.sniOnly)
      def techContact: Output[besom.api.akamai.outputs.CpsDvEnrollmentTechContact] = output.flatMap(_.techContact)
      def validationType: Output[String] = output.flatMap(_.validationType)

def cpsDvEnrollment(using ctx: Context)(
  name: NonEmptyString,
  args: CpsDvEnrollmentArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CpsDvEnrollment] = 
  ctx.registerResource[CpsDvEnrollment, CpsDvEnrollmentArgs]("akamai:index/cpsDvEnrollment:CpsDvEnrollment", name, args, opts)

