package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CpsDvEnrollmentArgs private(
  acknowledgePreVerificationWarnings: Output[Option[Boolean]],
  adminContact: Output[besom.api.akamai.inputs.CpsDvEnrollmentAdminContactArgs],
  allowDuplicateCommonName: Output[Option[Boolean]],
  certificateChainType: Output[Option[String]],
  commonName: Output[String],
  contractId: Output[String],
  csr: Output[besom.api.akamai.inputs.CpsDvEnrollmentCsrArgs],
  networkConfiguration: Output[besom.api.akamai.inputs.CpsDvEnrollmentNetworkConfigurationArgs],
  organization: Output[besom.api.akamai.inputs.CpsDvEnrollmentOrganizationArgs],
  sans: Output[Option[scala.collection.immutable.List[String]]],
  secureNetwork: Output[String],
  signatureAlgorithm: Output[String],
  sniOnly: Output[Boolean],
  techContact: Output[besom.api.akamai.inputs.CpsDvEnrollmentTechContactArgs]
) derives ArgsEncoder

object CpsDvEnrollmentArgs:
  def apply(
    acknowledgePreVerificationWarnings: Input.Optional[Boolean] = None,
    adminContact: Input[besom.api.akamai.inputs.CpsDvEnrollmentAdminContactArgs],
    allowDuplicateCommonName: Input.Optional[Boolean] = None,
    certificateChainType: Input.Optional[String] = None,
    commonName: Input[String],
    contractId: Input[String],
    csr: Input[besom.api.akamai.inputs.CpsDvEnrollmentCsrArgs],
    networkConfiguration: Input[besom.api.akamai.inputs.CpsDvEnrollmentNetworkConfigurationArgs],
    organization: Input[besom.api.akamai.inputs.CpsDvEnrollmentOrganizationArgs],
    sans: Input.Optional[List[Input[String]]] = None,
    secureNetwork: Input[String],
    signatureAlgorithm: Input[String],
    sniOnly: Input[Boolean],
    techContact: Input[besom.api.akamai.inputs.CpsDvEnrollmentTechContactArgs]
  )(using Context): CpsDvEnrollmentArgs =
    new CpsDvEnrollmentArgs(
      acknowledgePreVerificationWarnings = acknowledgePreVerificationWarnings.asOptionOutput(isSecret = false),
      adminContact = adminContact.asOutput(isSecret = false),
      allowDuplicateCommonName = allowDuplicateCommonName.asOptionOutput(isSecret = false),
      certificateChainType = certificateChainType.asOptionOutput(isSecret = false),
      commonName = commonName.asOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      csr = csr.asOutput(isSecret = false),
      networkConfiguration = networkConfiguration.asOutput(isSecret = false),
      organization = organization.asOutput(isSecret = false),
      sans = sans.asOptionOutput(isSecret = false),
      secureNetwork = secureNetwork.asOutput(isSecret = false),
      signatureAlgorithm = signatureAlgorithm.asOutput(isSecret = false),
      sniOnly = sniOnly.asOutput(isSecret = false),
      techContact = techContact.asOutput(isSecret = false)
    )
