package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CpsDvValidation private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  enrollmentId: Output[Int],
  sans: Output[Option[scala.collection.immutable.List[String]]],
  status: Output[String]
) extends CustomResource derives ResourceDecoder

object CpsDvValidation:
  given outputOps: {} with
    extension(output: Output[CpsDvValidation])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def enrollmentId: Output[Int] = output.flatMap(_.enrollmentId)
      def sans: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.sans)
      def status: Output[String] = output.flatMap(_.status)

def cpsDvValidation(using ctx: Context)(
  name: NonEmptyString,
  args: CpsDvValidationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CpsDvValidation] = 
  ctx.registerResource[CpsDvValidation, CpsDvValidationArgs]("akamai:index/cpsDvValidation:CpsDvValidation", name, args, opts)

