package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CpsDvValidationArgs private(
  enrollmentId: Output[Int],
  sans: Output[Option[scala.collection.immutable.List[String]]]
) derives ArgsEncoder

object CpsDvValidationArgs:
  def apply(
    enrollmentId: Input[Int],
    sans: Input.Optional[List[Input[String]]] = None
  )(using Context): CpsDvValidationArgs =
    new CpsDvValidationArgs(
      enrollmentId = enrollmentId.asOutput(isSecret = false),
      sans = sans.asOptionOutput(isSecret = false)
    )
