package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CpsThirdPartyEnrollment private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  acknowledgePreVerificationWarnings: Output[Option[Boolean]],
  adminContact: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentAdminContact],
  allowDuplicateCommonName: Output[Option[Boolean]],
  autoApproveWarnings: Output[Option[scala.collection.immutable.List[String]]],
  certificateChainType: Output[Option[String]],
  changeManagement: Output[Option[Boolean]],
  commonName: Output[String],
  contractId: Output[String],
  csr: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentCsr],
  excludeSans: Output[Option[Boolean]],
  networkConfiguration: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentNetworkConfiguration],
  organization: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentOrganization],
  sans: Output[Option[scala.collection.immutable.List[String]]],
  secureNetwork: Output[String],
  signatureAlgorithm: Output[Option[String]],
  sniOnly: Output[Boolean],
  techContact: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentTechContact]
) extends CustomResource derives ResourceDecoder

object CpsThirdPartyEnrollment:
  given outputOps: {} with
    extension(output: Output[CpsThirdPartyEnrollment])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def acknowledgePreVerificationWarnings: Output[Option[Boolean]] = output.flatMap(_.acknowledgePreVerificationWarnings)
      def adminContact: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentAdminContact] = output.flatMap(_.adminContact)
      def allowDuplicateCommonName: Output[Option[Boolean]] = output.flatMap(_.allowDuplicateCommonName)
      def autoApproveWarnings: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.autoApproveWarnings)
      def certificateChainType: Output[Option[String]] = output.flatMap(_.certificateChainType)
      def changeManagement: Output[Option[Boolean]] = output.flatMap(_.changeManagement)
      def commonName: Output[String] = output.flatMap(_.commonName)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def csr: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentCsr] = output.flatMap(_.csr)
      def excludeSans: Output[Option[Boolean]] = output.flatMap(_.excludeSans)
      def networkConfiguration: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentNetworkConfiguration] = output.flatMap(_.networkConfiguration)
      def organization: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentOrganization] = output.flatMap(_.organization)
      def sans: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.sans)
      def secureNetwork: Output[String] = output.flatMap(_.secureNetwork)
      def signatureAlgorithm: Output[Option[String]] = output.flatMap(_.signatureAlgorithm)
      def sniOnly: Output[Boolean] = output.flatMap(_.sniOnly)
      def techContact: Output[besom.api.akamai.outputs.CpsThirdPartyEnrollmentTechContact] = output.flatMap(_.techContact)

def cpsThirdPartyEnrollment(using ctx: Context)(
  name: NonEmptyString,
  args: CpsThirdPartyEnrollmentArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CpsThirdPartyEnrollment] = 
  ctx.registerResource[CpsThirdPartyEnrollment, CpsThirdPartyEnrollmentArgs]("akamai:index/cpsThirdPartyEnrollment:CpsThirdPartyEnrollment", name, args, opts)

