package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CpsThirdPartyEnrollmentArgs private(
  acknowledgePreVerificationWarnings: Output[Option[Boolean]],
  adminContact: Output[besom.api.akamai.inputs.CpsThirdPartyEnrollmentAdminContactArgs],
  allowDuplicateCommonName: Output[Option[Boolean]],
  autoApproveWarnings: Output[Option[scala.collection.immutable.List[String]]],
  certificateChainType: Output[Option[String]],
  changeManagement: Output[Option[Boolean]],
  commonName: Output[String],
  contractId: Output[String],
  csr: Output[besom.api.akamai.inputs.CpsThirdPartyEnrollmentCsrArgs],
  excludeSans: Output[Option[Boolean]],
  networkConfiguration: Output[besom.api.akamai.inputs.CpsThirdPartyEnrollmentNetworkConfigurationArgs],
  organization: Output[besom.api.akamai.inputs.CpsThirdPartyEnrollmentOrganizationArgs],
  sans: Output[Option[scala.collection.immutable.List[String]]],
  secureNetwork: Output[String],
  signatureAlgorithm: Output[Option[String]],
  sniOnly: Output[Boolean],
  techContact: Output[besom.api.akamai.inputs.CpsThirdPartyEnrollmentTechContactArgs]
) derives ArgsEncoder

object CpsThirdPartyEnrollmentArgs:
  def apply(
    acknowledgePreVerificationWarnings: Input.Optional[Boolean] = None,
    adminContact: Input[besom.api.akamai.inputs.CpsThirdPartyEnrollmentAdminContactArgs],
    allowDuplicateCommonName: Input.Optional[Boolean] = None,
    autoApproveWarnings: Input.Optional[List[Input[String]]] = None,
    certificateChainType: Input.Optional[String] = None,
    changeManagement: Input.Optional[Boolean] = None,
    commonName: Input[String],
    contractId: Input[String],
    csr: Input[besom.api.akamai.inputs.CpsThirdPartyEnrollmentCsrArgs],
    excludeSans: Input.Optional[Boolean] = None,
    networkConfiguration: Input[besom.api.akamai.inputs.CpsThirdPartyEnrollmentNetworkConfigurationArgs],
    organization: Input[besom.api.akamai.inputs.CpsThirdPartyEnrollmentOrganizationArgs],
    sans: Input.Optional[List[Input[String]]] = None,
    secureNetwork: Input[String],
    signatureAlgorithm: Input.Optional[String] = None,
    sniOnly: Input[Boolean],
    techContact: Input[besom.api.akamai.inputs.CpsThirdPartyEnrollmentTechContactArgs]
  )(using Context): CpsThirdPartyEnrollmentArgs =
    new CpsThirdPartyEnrollmentArgs(
      acknowledgePreVerificationWarnings = acknowledgePreVerificationWarnings.asOptionOutput(isSecret = false),
      adminContact = adminContact.asOutput(isSecret = false),
      allowDuplicateCommonName = allowDuplicateCommonName.asOptionOutput(isSecret = false),
      autoApproveWarnings = autoApproveWarnings.asOptionOutput(isSecret = false),
      certificateChainType = certificateChainType.asOptionOutput(isSecret = false),
      changeManagement = changeManagement.asOptionOutput(isSecret = false),
      commonName = commonName.asOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      csr = csr.asOutput(isSecret = false),
      excludeSans = excludeSans.asOptionOutput(isSecret = false),
      networkConfiguration = networkConfiguration.asOutput(isSecret = false),
      organization = organization.asOutput(isSecret = false),
      sans = sans.asOptionOutput(isSecret = false),
      secureNetwork = secureNetwork.asOutput(isSecret = false),
      signatureAlgorithm = signatureAlgorithm.asOptionOutput(isSecret = false),
      sniOnly = sniOnly.asOutput(isSecret = false),
      techContact = techContact.asOutput(isSecret = false)
    )
