package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class CpsUploadCertificate private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  acknowledgeChangeManagement: Output[Option[Boolean]],
  acknowledgePostVerificationWarnings: Output[Option[Boolean]],
  autoApproveWarnings: Output[Option[scala.collection.immutable.List[String]]],
  certificateEcdsaPem: Output[Option[String]],
  certificateRsaPem: Output[Option[String]],
  enrollmentId: Output[Int],
  trustChainEcdsaPem: Output[Option[String]],
  trustChainRsaPem: Output[Option[String]],
  unacknowledgedWarnings: Output[Boolean],
  waitForDeployment: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object CpsUploadCertificate:
  given outputOps: {} with
    extension(output: Output[CpsUploadCertificate])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def acknowledgeChangeManagement: Output[Option[Boolean]] = output.flatMap(_.acknowledgeChangeManagement)
      def acknowledgePostVerificationWarnings: Output[Option[Boolean]] = output.flatMap(_.acknowledgePostVerificationWarnings)
      def autoApproveWarnings: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.autoApproveWarnings)
      def certificateEcdsaPem: Output[Option[String]] = output.flatMap(_.certificateEcdsaPem)
      def certificateRsaPem: Output[Option[String]] = output.flatMap(_.certificateRsaPem)
      def enrollmentId: Output[Int] = output.flatMap(_.enrollmentId)
      def trustChainEcdsaPem: Output[Option[String]] = output.flatMap(_.trustChainEcdsaPem)
      def trustChainRsaPem: Output[Option[String]] = output.flatMap(_.trustChainRsaPem)
      def unacknowledgedWarnings: Output[Boolean] = output.flatMap(_.unacknowledgedWarnings)
      def waitForDeployment: Output[Option[Boolean]] = output.flatMap(_.waitForDeployment)

def cpsUploadCertificate(using ctx: Context)(
  name: NonEmptyString,
  args: CpsUploadCertificateArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[CpsUploadCertificate] = 
  ctx.registerResource[CpsUploadCertificate, CpsUploadCertificateArgs]("akamai:index/cpsUploadCertificate:CpsUploadCertificate", name, args, opts)

